/* ============ */
/* GenChiSq.c	*/
/* ============ */
#include <stdlib.h>
#include <stdio.h>
#include <defcodes.h>
#include <mconf.h>
#include <miscdefs.h>
#include <rundefs.h>

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */
extern	double	CalcChiSq F((struct RunDataStru *));
extern	void	GenerateChiSquareData F((struct RunDataStru *));

# undef F
/* INDENT ON */

/* ==================================================================== */
/* GenerateChiSquareData - Produces Array of Chi-Square Probabilities	*/
/* ==================================================================== */
void
GenerateChiSquareData(RUN_DATA_STRU * RunData)
{
    int     k;

    for (k = 0; k < NUM_PROBS; ++k)
    {
	/* --------------------------------- */
	/* Generate Block of Unique Variates */
	/* --------------------------------- */
	GenRunData(RunData);

	P(printf("Status of Call to GenRunData(): %s\n\n",
	    (RunData->CallStatus == TRUE) ? "SUCCESS" : "FAILURE"));

	if (RunData->CallStatus != TRUE)
	{
	    fprintf(stderr,
		"\nGenerateChiSquareData: "
		"Generator Failure in GenRunData().\n");
	    break;
	}
	/* ------------- */
	/* Count Runs Up */
	/* ------------- */
	CountRuns(RunData);

	/* -------------------------------- */
	/* Calculate Chi-square Probability */
	/* -------------------------------- */
	RunData->ChiSqProb[k] = CalcChiSq(RunData);

	fprintf(stderr, "\rPass %3d (of %d), %8ld  Total Random Numbers",
	    k+1, NUM_PROBS, RunData->TotVariates);
    }
}
/* ==================================================================== */
/* CalcChiSq - Calculates Chi-square statistic, Returns Probability		*/
/* ==================================================================== */
double
CalcChiSq(RUN_DATA_STRU *RunData)
{
    UINT i;
    double  ChiSqProb, ChiSqVal = 0;

    static
    double  RunProb[MAX_RUN_CATS] =
	{ 1./2., 1./3., 1./8., 1./30., 1./144., 1./720. };

    for (i = 1; i <= MAX_RUN_CATS; ++i)
    {
	double	Expected;

	Expected = (double)RunData->RunCtrs[0] * RunProb[i-1];
	ChiSqVal += SQR((double)RunData->RunCtrs[i]) / Expected;
	P(printf("%5u:\t%5ld%10.2f%9.3f%%\n",
	    i, RunData->RunCtrs[i], Expected, 100*RunProb[i-1]));
    }

    ChiSqVal -= (double)RunData->RunCtrs[0];
    ChiSqProb =	chdtr(DEG_FREE, ChiSqVal);

    P(printf("Total:\t%5ld   Number of Runs This Pass\n\n",
	RunData->RunCtrs[0]));
    P(printf("%6.3f   Chi-Square for This Pass\n", ChiSqVal));
    P(printf("%6.2f%%  Chi-Square Probability\n\n", ChiSqProb*100));

    return (ChiSqProb);
}
